package eqsolver;

public class ModelQuadraticEquation implements IEquation,ISolver {

	private int numberParam;
	private float[] param = new float[3];

	@Override
	public void setEquation(int numberParam, float[] param) {
		if (param == null) {
			param = new float[3];
		}
		for (int i = 0; i < numberParam; i++) {
			this.param[i] = param[i];
		}
		this.numberParam = numberParam;
		//System.out.println(param[0] + " " + param[1] + " " + param[2]);
	}
	
	public void solve() {
		//non c'è l'utilità adesso
	}

	public float[] getSol() {

		float a = param[0];
		float b = param[1];
		float c = param[2];
		float[] x = new float[2];

		float delta = b * b - 4 * a * c;

		if (a==0) {
			
			param[0]=b;
			param[1]=c;
			IEquation linearequ1 = new ModelLinearEquation();
			linearequ1.setEquation(2, param);
			x[0] = linearequ1.getSol()[0];
			x[1] = linearequ1.getSol()[0];
			return x;
			
		}
		
		if (delta >= 0) {
			x[0] = (int) (-b + (float) Math.sqrt(delta)) / (2 * a);

			x[1] = (int) (-b - (float) Math.sqrt(delta)) / (2 * a);
		} else {
			x[0] = 999;
			x[1] = 999;
		}

		return x;
	}

	public float[] getParam() {
		return param;
	}

	public int getNumberParam() {
		return numberParam;
	}
}
